#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//genuary7_2023Mod01.fsh  by  nafees
//https://www.shadertoy.com/view/cl2GWz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const vec2 cent = vec2(0.5);
#define rot(a) mat2(cos(a), -sin(a), sin(a), cos(a))
#define hue(v) ( .6 + .6 * cos( 2.*PI*(v) + vec3(0,-2.*PI/3.,2.*PI/3.) ) ) 
#define PI 3.14159

// hail to the thief
vec3 palette[10] = vec3[10](
vec3(0.042656201869249344, 0.25434625148773193, 0.5165957808494568),
vec3(0.08686035871505737, 0.15766902267932892, 0.1489642858505249),
vec3(0.48808541893959045, 0.6333185434341431, 0.7216861248016357),
vec3(0.39730414748191833, 0.31950247287750244, 0.23948518931865692),
vec3(0.9039696455001831, 0.4972691237926483, 0.09944970905780792),
vec3(0.28027260303497314, 0.5017772316932678, 0.6329017281532288),
vec3(0.7951585650444031, 0.10339261591434479, 0.12999267876148224),
vec3(0.9240946173667908, 0.9441264271736145, 0.9521055817604065),
vec3(0.04767867177724838, 0.38672053813934326, 0.2592359781265259),
vec3(0.7265218496322632, 0.7588484287261963, 0.7720305919647217)
);

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float xsize = 0.1;
    float t = iTime * 0.1;
    
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = 3.*((fragCoord/iResolution.y) 
                - vec2(fract(iResolution.x/iResolution.y)*.5,0.));
                // x dimension runs from 0 to xaspect. so shift by 0.5*(1-xaspect)

    // calculate grid coordinates
    vec2 gc = (uv / xsize);

    uv = uv.yx;
    uv.x += (sin(t*4.)+.5)*0.5*2.-0.;
    gc = sin(0.5) * vec2(exp(uv.x) * cos(uv.y), exp(uv.x) * sin(uv.y)).yy;
    //gc *= -rot(t*2.);
    gc.x += -t*4.;
    //gc *= rot(t*.1);
    
    vec2 voxel = floor(gc);
    
    vec2 localP = fract(gc) - cent;

    // Time varying voxel color
    vec3 col = palette[int(abs(voxel.x)) % 10]
          * (1.-length(localP)); // mask distance from center of voxel


    fragColor = vec4(pow(col,vec3(1./2.2)),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

